Node = class.new();

function Node:constructor(x, y)
	self.x				=	x;
	self.y				=	y;
	self.connections	=	{};
	self.gCost			=	0;
	self.hCost			=	0;
	self.parent			=	nil;
end

function Node:getConnections()
	return self.connections;
end


function Node:findConnection(node)
	local function nodeCompare(node1, node2)
		if( node1.x == node2.x and node1.y == node2.y ) then
			return true;
		end
		return false;
	end

	for i,v in pairs(self.connections) do
		if( nodeCompare(v, node) ) then
			return i;
		end
	end
end

function Node:addConnection(node, bothways)
	if( not self:findConnection(node) ) then
		--printf("Adding connection from (%d,%d) to (%d,%d)\n", self.x, self.y, node.x, node.y);
		table.insert(self.connections, node);
	end

	if( bothways ) then
		node:addConnection(self);
	end
end

function Node:removeConnection(node)
	local index = self:findConnection(node);
	if( index ) then
		table.remove(self.connections, index);
	end
end

-- The parent of a node is the node that leads into it (shortest path)
function Node:getParent()
	return self.parent;
end

function Node:setParent(p)
	self.parent	=	p;
end

-- Accumulated step cost
function Node:getGCost()
	return self.gCost;
end

function Node:setGCost(g)
	self.gCost = g;
end

-- Cost to target
function Node:getHCost()
	return self.hCost;
end

function Node:setHCost(h)
	self.hCost = h;
end


-- Full cost (g + h)
function Node:getFCost()
	return self.gCost + self.hCost;
end