-- This is just a list of timezones and their offsets
-- Where there are naming clashes, the more obvious (usually by population) takes precedent
-- See: http://en.wikipedia.org/wiki/List_of_time_zone_abbreviations

timezone = {
	ACDT	=	10.5,
	ACST	=	9.5,
	ACT		=	8,
	ADT		=	-3,
	AEDT	=	11,
	AEST	=	10,
	AFT		=	4.5,
	AKDT	=	-8,
	AKST	=	-9,
	AMST	=	-3,		-- Amazon Summer Time (Brazil)
	AMST2	=	5,		-- Armenia Summer Time
	AMT		=	-4,		-- Amazon Time (Brazil)
	AMT2	=	4,		-- Armenia Time
	ART		=	-3,
	AST		=	-4,		-- Atlantic Standard Time
	AST2	=	3,		-- Arabia Standard Time
	AWDT	=	9,
	AWST	=	8,
	AZOST	=	-1,
	AZT		=	-1,
	BDT		=	8,
	BIOT	=	6,
	BIT		=	-12,
	BOT		=	-4,
	BRT		=	-3,
	BST		=	1,		-- British Standard Time
	BST2	=	6,		-- Bangladesh Standard Time
	BTT		=	6,
	CAT		=	2,
	CCT		=	6.5,
	CDT		=	-5,		-- Central Daylight Time (US)
	CDT2	=	-4,		-- Cuba Daylight Time
	CEDT	=	2,
	CEST	=	2,
	CET		=	1,
	CHADT	=	13.75,
	CHAST	=	12.75,
	CHOT	=	8,
	CHST	=	10,
	CHUT	=	10,
	CIST	=	-8,
	CIT		=	8,
	CKT		=	-10,
	CLST	=	-3,
	CLT		=	-4,
	COST	=	-4,
	COT		=	-5,
	CST		=	-6,		-- Central Standard Time (US)
	CST2	=	8,		-- China Standard Time
	CST3	=	9.5,	-- Central Standard Time (Australia)
	CST4	=	10.5,	-- Central Summer Time (Australia)
	CT		=	8,
	CVT		=	-1,
	CWST	=	8.75,
	CXT		=	7,
	DAVT	=	7,
	DDUT	=	10,
	DFT		=	1,
	EASST	=	-5,
	EAST	=	-6,
	EAT		=	3,
	ECT		=	-4,
	ECT2	=	-5,
	EDT		=	-4,
	EEDT	=	3,
	EEST	=	3,
	EET		=	2,
	EGST	=	0,
	EGT		=	-1,
	EIT		=	9,
	EST		=	-5,		-- Eastern Standard Time (US)
	EST2	=	10,	-- Eastern Standard Time (Australia)
	FET		=	3,
	FJT		=	12,
	FKST	=	-3,		-- Note; there's two FKST, but both have the same offset anyways
	FKT		=	-4,
	FNT		=	-2,
	GALT	=	-6,
	GAMT	=	-9,
	GET		=	4,
	GFT		=	-3,
	GILT	=	12,
	GIT		=	-9,
	GMT		=	0,
	GST		=	-2,		-- South Georgia and the South Sandwich Islands
	GST2	=	4,		-- Gulf Standard Time
	GYT		=	-4,
	HADT	=	-9,
	HAEC	=	2,
	HAST	=	-10,
	HKT		=	8,
	HMT		=	5,
	HOVT	=	7,
	HST		=	-10,
	ICT		=	7,
	IDT		=	3,
	IOT		=	3,
	IRDT	=	4.5,
	IRKT	=	8,
	IRST	=	3.5,
	IST		=	5.5,	-- Indian Standard Time
	IST2	=	1,		-- Irish Standard Time
	IST3	=	2,		-- Israel Standard Time
	JST		=	9,
	KGT		=	6,
	KOST	=	11,
	KRAT	=	7,
	KST		=	9,
	LHST	=	10.5,	-- Lord Howe Standard Time
	LHST2	=	11,	-- Lord Howe Summer Time
	LINT	=	14,
	MAGT	=	12,
	MART	=	-9.5,
	MAWT	=	5,
	MDT		=	-6,
	MET		=	1,
	MEST	=	2,
	MHT		=	12,
	MIST	=	11,
	MIT		=	-9.5,
	MMT		=	6.5,
	MSK		=	3,
	MST		=	-7,		-- Mountain Standard Time (US)
	MST2	=	8,		-- Malaysia Standard Time
	MST3	=	6.5,	-- Myanmar Standard Time
	MUT		=	4,
	MVT		=	5,
	MYT		=	8,
	NCT		=	11,
	NDT		=	-2.5,
	NFT		=	11.5,
	NPT		=	5.75,
	NST		=	-3.5,
	NT		=	-3.5,
	NUT		=	-11,
	NZDT	=	13,
	NZST	=	12,
	OMST	=	6,
	ORAT	=	5,
	PDT		=	-7,
	PET		=	-5,
	PETT	=	12,
	PGT		=	10,
	PHOT	=	13,
	PKT		=	5,
	PMDT	=	-2,
	PMST	=	-3,
	PONT	=	11,
	PST		=	-8,
	PST2	=	8,
	PYST	=	-3,
	PYT		=	-4,
	RET		=	4,
	ROTT	=	-3,
	SAKT	=	11,
	SAMT	=	4,
	SAST	=	2,
	SBT		=	11,
	SCT		=	4,
	SGT		=	8,
	SLST	=	5.5,
	SRET	=	11,
	SRT		=	-3,
	SST		=	-11,
	SST2	=	8,
	SYOT	=	3,
	TAHT	=	-10,
	THA		=	7,
	TFT		=	5,
	TJT		=	5,
	TKT		=	13,
	TLT		=	9,
	TMT		=	5,
	TOT		=	13,
	TVT		=	12,
	UCT		=	0,
	ULAT	=	8,
	USZ1	=	2,
	UTC		=	0,
	UYST	=	-2,
	UYT		=	-3,
	UZT		=	5,
	VET		=	-4.5,
	VLAT	=	10,
	VOLT	=	4,
	VOST	=	6,
	VUT		=	11,
	WAKT	=	12,
	WAST	=	2,
	WAT		=	1,
	WEDT	=	1,
	WEST	=	1,
	WET		=	0,
	WIT		=	7,
	WST		=	8,
	YAKT	=	9,
	YEKT	=	5,
	Z		=	0,
};

return timezone;