#ifndef TIMER_H
#define TIMER_H

	#include "wininclude.h"

	typedef LARGE_INTEGER   TimeType;

	namespace timer
	{
		extern LARGE_INTEGER frequency;
	}

	class Timer
	{
		protected:
			TimeType startTime; // Time when started
			double triggerTime; // How often it will trigger (in miliseconds)

		public:
			Timer();
			Timer(double);
			void start(double);
			bool triggered();
	};


	TimeType getNow();
	TimeType getTimerFrequency();
	double deltaTime(TimeType, TimeType);
	double getTimeElapsed(TimeType);
#endif
