#include "settings.h"

Settings *Settings::pinstance = NULL;

Settings::Settings()
{

}

Settings *Settings::instance()
{
	if( !pinstance )
		pinstance = new Settings;

	return pinstance;
}

void Settings::setString(const char *key, std::string sValue)
{
	settingsmap[key].sValue = sValue;
}

void Settings::setFloat(const char *key, double fValue)
{
	settingsmap[key].fValue = fValue;
}

void Settings::setBool(const char *key, bool bValue)
{
	settingsmap[key].bValue = bValue;
}

std::string Settings::getString(const char *key)
{
	t_settingsmap::iterator foundpos = settingsmap.find(key);
	if( foundpos != settingsmap.end() )
	{
		return foundpos->second.sValue;
	}
		return "";
}

double Settings::getFloat(const char *key)
{
	t_settingsmap::iterator foundpos = settingsmap.find(key);
	if( foundpos != settingsmap.end() )
	{
		return foundpos->second.fValue;
	}
		return 0.0;
}

bool Settings::getBool(const char *key)
{
	t_settingsmap::iterator foundpos = settingsmap.find(key);
	if( foundpos != settingsmap.end() )
	{
		return foundpos->second.bValue;
	}
		return false;
}

void Settings::clearSettings()
{
	settingsmap.clear();
}
