local global = _G;
require "classes";

Quaternion = class();

function Quaternion:constructor(a)
	self.w, self.x, self.y, self.z = 1, 0, 0, 0;
end

function Quaternion:__mul(q2)
	if( type(q2) ~= "table" or q2.is_a == nil or not q2:is_a(Quaternion) ) then
		error("Both objects must be a quaternion.", 2);
	end

	local tmp = Quaternion();
	tmp.w = (self.w*q2.w - self.x*q2.x - self.y*q2.y - self.z*q2.z);
	tmp.x = (self.w*q2.x + self.x*q2.w + self.y*q2.z - self.z*q2.y);
	tmp.y = (self.w*q2.y - self.x*q2.z + self.y*q2.w + self.z*q2.x);
	tmp.z = (self.w*q2.z + self.x*q2.y - self.y*q2.x + self.z*q2.w);

	return tmp;
end